// PageSettingScreenCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingScreenCtrl.h"


// CPageSettingScreenCtrl dialog

IMPLEMENT_DYNAMIC(CPageSettingScreenCtrl, CDialog)

CPageSettingScreenCtrl::CPageSettingScreenCtrl(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingScreenCtrl::IDD, pParent)
	, m_iScreen(0)
	, m_csAddress(_T(""))
{

}

CPageSettingScreenCtrl::~CPageSettingScreenCtrl()
{
}

void CPageSettingScreenCtrl::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_COM, m_cboCom);
	DDX_Control(pDX, IDC_COMBO_PROTOCOL, m_cboProtocol);
	DDX_Text(pDX, IDC_EDIT_SCREENNO, m_iScreen);
	DDX_Text(pDX, IDC_EDIT_SCREENADDR, m_csAddress);
	DDV_MaxChars(pDX, m_csAddress, 10);
	DDX_Control(pDX, IDC_COMBO_SCREENNO, m_cboScreenNo);
	DDX_Control(pDX, IDC_COMBO_ACTIONTYPE, m_cboType);
	DDX_Control(pDX, IDC_COMBO_PARAM, m_cboParam);
	DDX_Control(pDX, IDC_LIST_SCREENCTRL, m_lstScreenCtrl);
}


BEGIN_MESSAGE_MAP(CPageSettingScreenCtrl, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_SET_SCREENCTL, &CPageSettingScreenCtrl::OnBnClickedButtonSetScreenctl)
	ON_BN_CLICKED(IDC_BUTTON_SET_CMD, &CPageSettingScreenCtrl::OnBnClickedButtonSetCmd)
	ON_NOTIFY(NM_CLICK, IDC_LIST_SCREENCTRL, &CPageSettingScreenCtrl::OnNMClickListScreenctrl)
	ON_CBN_SELCHANGE(IDC_COMBO_ACTIONTYPE, &CPageSettingScreenCtrl::OnCbnSelchangeComboActiontype)
END_MESSAGE_MAP()


// CPageSettingScreenCtl message handlers
int   CPageSettingScreenCtrl::Initialize(TDECPARAM* _pdecParam)
{
	LoadSurfaceResource();

	int iCom = 0;
	m_cboCom.ResetContent();

	for (int i = 0; i < _pdecParam->m_iComNumber; i++)
	{
		CString Name;
		Name.Format("RS485-%d", i+1);
		m_cboCom.AddString(Name);
	}
	m_cboCom.SetCurSel(0);

	ScreenCtlProtocols tScp = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_GETSCREENCTLPROTOCOLS,\
		&tScp,sizeof(ScreenCtlProtocols));
	if(ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CPageSettingScreenCtrl::UpdateInfo] DEC_ClientGetDevConfig Failed! \
								Ret(%d),CMDID(CMD_DEC_CFG_GETSCREENCTLPROTOCOLS)",iRet);
		return ERR_INVALIDPARA;
	}

	for (int i = 0; i < tScp.iCount && i < MAX_PROTOCOL_NUM; i++)
	{
		m_cboProtocol.AddString(tScp.cProtocol[i]);
	}

	m_cboProtocol.SetCurSel(0);

	//ȡ豸ͨ
	tDevInfo tDevInfomation = {0};
	iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_DEV_INFO, &tDevInfomation, sizeof(tDevInfo));
	if(iRet < ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_WARN,"DEC_ClientGetDevConfig");
	}

	for (int i = 0; i < tDevInfomation.iChanNum && i < DEC_MAX_PHYSICAL_CHANNEL_NUM; i++)
	{
		CString tmp;
		tmp.Format("%d",i);
		m_cboScreenNo.AddString(tmp);
	}
	m_cboScreenNo.SetCurSel(0);

	m_cboType.ResetContent();
	m_cboType.AddString("1:ػ");
	m_cboType.AddString("2:ƴѡ");
	m_cboType.AddString("3:Աȶ");
	m_cboType.AddString("4:");
	m_cboType.AddString("5:ɫͶ");
	m_cboType.AddString("6:");
	m_cboType.SetCurSel(0);
	OnCbnSelchangeComboActiontype();


	m_lstScreenCtrl.SetExtendedStyle(m_lstScreenCtrl.GetExtendedStyle() | LVS_SHOWSELALWAYS);
	m_lstScreenCtrl.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);

	InsertColumn(m_lstScreenCtrl,0,GetTextByLan("Ļ","No."),LVCFMT_LEFT,60);
	InsertColumn(m_lstScreenCtrl,1,GetTextByLan("Ļַ","Address"),LVCFMT_LEFT,80);
	InsertColumn(m_lstScreenCtrl,2,GetTextByLan("ڱ","COM"),LVCFMT_LEFT,70);
	InsertColumn(m_lstScreenCtrl,3,GetTextByLan("Э","Protocol"),LVCFMT_LEFT,130);

	UpdateInfo();


	return ERR_SUCCESS;
}

void CPageSettingScreenCtrl::OnParamChangeNotify(_CHANGE_PARAM_NOTIFY_DATA* pData)
{
	switch(pData->m_iMsg)
	{
	case DEC_PARACHANGE_SCREENCRLPROTOCOL:
		{
			//ı
			ScreenCtlProtocol &tScp = pData->tParam.tScreenCtlProtocol;
			int iIndex = tScp.iScreenNo;

			CString csTmp;
			csTmp.Format("%d",tScp.iScreenNo);
			m_lstScreenCtrl.SetItemText(tScp.iScreenNo,0,csTmp);
			csTmp.Format("0x%02x",tScp.iAddressNo);
			m_lstScreenCtrl.SetItemText(tScp.iScreenNo,1,csTmp);
			csTmp.Format("%d",tScp.iComNo);
			m_lstScreenCtrl.SetItemText(tScp.iScreenNo,2,csTmp);
			m_lstScreenCtrl.SetItemText(tScp.iScreenNo,3,tScp.cProtocol);
		}
		break;
	default:
		break;
	}
}
void CPageSettingScreenCtrl::OnMainNotify(_MAIN_NOTIFY_DATA* _pData)
{
	int iType = _pData->m_iMsg;
	int iID = _pData->m_lID;
	switch(iType)
	{
	case DEC_WCM_DEC_SCREENCTLSET:
		{
			//0Ԥ1ɹ2ʧ
			CString info;
			info.Format("iScreenNo = %d,iActionType = %d,iParam = %d",_pData->tParam.tScreenCtlResult.iScreenNo,
				_pData->tParam.tScreenCtlResult.iActionType,_pData->tParam.tScreenCtlResult.iParam);
			if(NOTIFY_SUCCESS == _pData->tParam.tScreenCtlResult.iResult)
			{
				info += GetTextByLan("óɹ","success");
				SetDlgItemText(IDC_STATIC_INFO,info);
			}
			else if(NOTIFY_FAILD == _pData->tParam.tScreenCtlResult.iResult)
			{
				info += GetTextByLan("ʧ","Faild");
				SetDlgItemText(IDC_STATIC_INFO,info);
			}
			break;
		}
	default:
		break;
	}
}


void  CPageSettingScreenCtrl::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STATIC_SCREENNO, GetTextByLan("Ļ","Screen No"));
	SetDlgItemText(IDC_STATIC_PICNO, GetTextByLan("Ļַ","Screen Address"));
	SetDlgItemText(IDC_STATIC_COMNO, GetTextByLan("ڱ","COM"));
	SetDlgItemText(IDC_STATIC_PROTOCOL, GetTextByLan("Э","Protocol Name"));
	SetDlgItemText(IDC_STATIC_SET_SCREENNO,  GetTextByLan("Ļ","Screen No"));
	SetDlgItemText(IDC_STATIC_ACTIONTYPE, GetTextByLan("","Action Type"));
	SetDlgItemText(IDC_STATIC_PARAM, GetTextByLan("","Param"));
	SetDlgItemText(IDC_BUTTON_SET_SCREENCTL, GetTextByLan("","Set"));
	SetDlgItemText(IDC_BUTTON_SET_CMD, GetTextByLan("","Set"));
}

void  CPageSettingScreenCtrl::UpdateInfo()
{
	//ȡ豸ͨ
	tDevInfo tDevInfomation = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_DEV_INFO, &tDevInfomation, sizeof(tDevInfo));
	if(iRet < ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_WARN,"DEC_ClientGetDevConfig");
		return ;
	}

	m_lstScreenCtrl.DeleteAllItems();
	for (int i = 0; i < tDevInfomation.iChanNum; i++)
	{
		ScreenCtlProtocol tScp = {0};
		tScp.iScreenNo = i;
		int iRet = DEC_ClientGetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_SCREENCRL_PROTOCOL,&tScp,sizeof(ScreenCtlProtocol));
		if(iRet < ERR_SUCCESS)
		{
			continue;;
		}
		CString csTmp;
		csTmp.Format("%d",i);
		m_lstScreenCtrl.InsertItem(i,csTmp);
		csTmp.Format("0x%02x",tScp.iAddressNo);
		m_lstScreenCtrl.SetItemText(i,1,csTmp);
		csTmp.Format("%d",tScp.iComNo);
		m_lstScreenCtrl.SetItemText(i,2,csTmp);
		m_lstScreenCtrl.SetItemText(i,3,tScp.cProtocol);
	}

	UpdateProtocol(0);
}



void CPageSettingScreenCtrl::OnBnClickedButtonSetScreenctl()
{
	// TODO: Add your control notification handler code here
	if(m_lLogonID < 0)
	{
		return;
	}

	UpdateData(TRUE);
	ScreenCtlProtocol tScp = {0};
	tScp.iScreenNo = m_iScreen;
	tScp.iComNo = m_cboCom.GetCurSel();
	
	char *str = NULL;
	tScp.iAddressNo = (int)strtol(m_csAddress.GetBuffer(0), &str, 16);

	if(tScp.iAddressNo < 17 || tScp.iAddressNo >  170)
	{
		MessageBox("ַ벻ڷΧ0x11-0xAA");
		return;
	}

	CString csProtocol;
	m_cboProtocol.GetWindowText(csProtocol);
	strcpy_s(tScp.cProtocol,sizeof(tScp.cProtocol),csProtocol.GetBuffer(0));

	int iRet = DEC_ClientSetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_SCREENCRL_PROTOCOL,&tScp,sizeof(ScreenCtlProtocol));
	if(iRet < ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR, "[CPageSettingScreenCtrl::OnBnClickedButtonSetScreenctl] DEC_ClientSetDevConfig Failed! \
								Ret(%d),CMDID(CMD_DEC_CFG_SCREENCRL_PROTOCOL)",iRet);
		return;
	}
}

void CPageSettingScreenCtrl::OnBnClickedButtonSetCmd()
{
	// TODO: Add your control notification handler code here

	ScreenCtl tScreenCtl = {0};
	tScreenCtl.iScreenNo = m_cboScreenNo.GetCurSel();
	tScreenCtl.iActionType = m_cboType.GetCurSel()+1;
	tScreenCtl.iParam = m_cboParam.GetCurSel();

	int iRet = DEC_ClientSendCommand(m_lLogonID, 0, 0, DEC_COMMAND_SCREENCTLSET, &tScreenCtl, sizeof(ScreenCtl));
	if (ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CPageSettingScreenCtrl::CmdPicSnap] OnBnClickedButtonSetCmd Failed!\
								Ret(%d),CMDID(DEC_COMMAND_SCREENCTLSET)",iRet);
	}

}

void CPageSettingScreenCtrl::OnNMClickListScreenctrl(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	// TODO: Add your control notification handler code here
	int iItem = pNMItemActivate->iItem;
	if (iItem >= 0)
	{
		UpdateProtocol(iItem);
	}
	*pResult = 0;
}
void CPageSettingScreenCtrl::UpdateProtocol(int _iScreenNo)
{
	ScreenCtlProtocol tScp = {0};

	tScp.iScreenNo = _iScreenNo;
	int iRet = DEC_ClientGetDevConfig(m_lLogonID,0,0,CMD_DEC_CFG_SCREENCRL_PROTOCOL,&tScp,sizeof(ScreenCtlProtocol));
	if(iRet < ERR_SUCCESS)
	{
		AddLog(LOG_LEVEL_ERROR, "[CPageSettingScreenCtrl::OnNMClickListScreenctrl] DEC_ClientGetDevConfig Failed! \
								Ret(%d),CMDID(CMD_DEC_CFG_SCREENCRL_PROTOCOL)",iRet);
		return;
	}

	m_iScreen = _iScreenNo;
	m_csAddress.Format("0x%02x",tScp.iAddressNo);
	m_cboCom.SetCurSel(tScp.iComNo);

	int iIndex = m_cboProtocol.FindStringExact(-1,tScp.cProtocol);
	if(iIndex > -1)
	{
		m_cboProtocol.SetCurSel(iIndex);
	}
	UpdateData(FALSE);
}

void CPageSettingScreenCtrl::OnCbnSelchangeComboActiontype()
{
	m_cboParam.ResetContent();
	// TODO: Add your control notification handler code here
	switch (m_cboType.GetCurSel()+1)
	{
	case On_Off:
		m_cboParam.AddString(GetTextByLan("ػ","Power Off"));
		m_cboParam.AddString(GetTextByLan("","Power On"));
		break;
	case Screen_Select:
		m_cboParam.AddString("AV");
		m_cboParam.AddString("S-VIDEO");
		m_cboParam.AddString("VGA");
		m_cboParam.AddString("DVI");
		m_cboParam.AddString("HDMI");
		break;
	case Contrast:
	case Lightness:
	case Saturation:
	case Clarity:
		m_cboParam.AddString(GetTextByLan("","Decrease"));
		m_cboParam.AddString(GetTextByLan("","Increase"));
		break;
	default:
		break;

	}
	m_cboParam.SetCurSel(0);
}
